/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.mixin;

import com.nyfaria.numismaticoverhaul.cap.CurrencyHolder;
import com.nyfaria.numismaticoverhaul.cap.CurrencyHolderAttacher;
import com.nyfaria.numismaticoverhaul.currency.CurrencyHelper;
import com.nyfaria.numismaticoverhaul.init.ItemInit;
import com.nyfaria.numismaticoverhaul.item.CoinItem;
import com.nyfaria.numismaticoverhaul.item.MoneyBagItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MerchantMenu.class})
public class MerchantScreenHandlerMixin {
    @Shadow
    @Final
    private Merchant f_40027_;

    @Redirect(method={"moveFromInventoryToPaymentSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isSameItemSameTags(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z"))
    public boolean isSameItemSameTags(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41720_() instanceof CoinItem) {
            return stack1.m_41720_() == stack2.m_41720_();
        }
        return ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    @Inject(method={"moveFromInventoryToPaymentSlot"}, at={@At(value="TAIL")})
    public void autofillOverride(int slot, ItemStack stack, CallbackInfo ci) {
        MerchantMenu handler = (MerchantMenu)this;
        CurrencyHolder playerBalance = CurrencyHolderAttacher.getExampleHolderUnwrap((Entity)((Inventory)handler.m_38853_((int)3).f_40218_).f_35978_);
        if (stack.m_41720_() instanceof CoinItem) {
            MerchantScreenHandlerMixin.numismatic$autofillWithCoins(slot, stack, handler, playerBalance);
        } else if (stack.m_41720_() == ItemInit.MONEY_BAG.get()) {
            MerchantScreenHandlerMixin.autofillWithMoneyBag(slot, stack, handler, playerBalance);
        }
        if (slot == 1) {
            playerBalance.commitTransactions();
        }
    }

    private static void numismatic$autofillWithCoins(int slot, ItemStack stack, MerchantMenu handler, CurrencyHolder playerBalance) {
        long presentCurrency;
        long requiredCurrency = ((CoinItem)stack.m_41720_()).currency.getRawValue(stack.m_41613_());
        if (requiredCurrency <= (presentCurrency = ((CoinItem)stack.m_41720_()).currency.getRawValue(handler.m_38853_(slot).m_7993_().m_41613_()))) {
            return;
        }
        long neededCurrency = requiredCurrency - presentCurrency;
        if (neededCurrency > playerBalance.getValue()) {
            return;
        }
        playerBalance.pushTransaction(-neededCurrency);
        ((Slot)handler.f_38839_.get(slot)).m_5852_(stack.m_41777_());
    }

    private static void autofillWithMoneyBag(int slot, ItemStack stack, MerchantMenu handler, CurrencyHolder playerBalance) {
        long availableCurrencyInPlayerInventory;
        if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)handler.m_38853_(slot).m_7993_())) {
            return;
        }
        Player player = ((Inventory)handler.m_38853_((int)3).f_40218_).f_35978_;
        long requiredCurrency = ((MoneyBagItem)ItemInit.MONEY_BAG.get()).getValue(stack);
        long neededCurrency = requiredCurrency - (availableCurrencyInPlayerInventory = CurrencyHelper.getMoneyInInventory(player, false));
        if (neededCurrency > playerBalance.getValue()) {
            return;
        }
        if (neededCurrency <= 0L) {
            CurrencyHelper.deduceFromInventory(player, requiredCurrency);
        } else {
            CurrencyHelper.deduceFromInventory(player, availableCurrencyInPlayerInventory);
            playerBalance.pushTransaction(-neededCurrency);
        }
        ((Slot)handler.f_38839_.get(slot)).m_5852_(stack.m_41777_());
    }

    @Inject(method={"playTradeSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkForEntityOnYes(CallbackInfo ci) {
        if (!(this.f_40027_ instanceof Entity)) {
            ci.cancel();
        }
    }
}

